"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub, ctx, placement_name: str, project_name: str, attributes: Dict = None
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an empty placement.

    Args:
        placement_name(str): The name of the placement to be created.
        project_name(str): The name of the project in which to create the placement.
        attributes(Dict, optional): Optional user-defined key/value pairs providing contextual data (such as location or function) for the placement. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot1click_project.placement.create(
                ctx, placement_name=value, project_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot1click_project.placement.create placement_name=value, project_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot1click-projects",
        operation="create_placement",
        op_kwargs={
            "placementName": placement_name,
            "projectName": project_name,
            "attributes": attributes,
        },
    )


async def delete(hub, ctx, placement_name: str, project_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a placement. To delete a placement, it must not have any devices associated with it.  When you delete a placement, all associated data becomes irretrievable.

    Args:
        placement_name(str): The name of the empty placement to delete.
        project_name(str): The project containing the empty placement to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot1click_project.placement.delete(
                ctx, placement_name=value, project_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot1click_project.placement.delete placement_name=value, project_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot1click-projects",
        operation="delete_placement",
        op_kwargs={"placementName": placement_name, "projectName": project_name},
    )


async def describe(hub, ctx, placement_name: str, project_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes a placement in a project.

    Args:
        placement_name(str): The name of the placement within a project.
        project_name(str): The project containing the placement to be described.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot1click_project.placement.describe(
                ctx, placement_name=value, project_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot1click_project.placement.describe placement_name=value, project_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot1click-projects",
        operation="describe_placement",
        op_kwargs={"placementName": placement_name, "projectName": project_name},
    )


async def list_all(
    hub, ctx, project_name: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the placement(s) of a project.

    Args:
        project_name(str): The project containing the placements to be listed.
        next_token(str, optional): The token to retrieve the next set of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return per request. If not set, a default value of 100 is used. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot1click_project.placement.list_all(ctx, project_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot1click_project.placement.list_all project_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot1click-projects",
        operation="list_placements",
        op_kwargs={
            "projectName": project_name,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )


async def update(
    hub, ctx, placement_name: str, project_name: str, attributes: Dict = None
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a placement with the given attributes. To clear an attribute, pass an empty value (i.e., "").

    Args:
        placement_name(str): The name of the placement to update.
        project_name(str): The name of the project containing the placement to be updated.
        attributes(Dict, optional): The user-defined object of attributes used to update the placement. The maximum number of key/value pairs is 50. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot1click_project.placement.update(
                ctx, placement_name=value, project_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot1click_project.placement.update placement_name=value, project_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot1click-projects",
        operation="update_placement",
        op_kwargs={
            "placementName": placement_name,
            "projectName": project_name,
            "attributes": attributes,
        },
    )
