"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def associate(
    hub,
    ctx,
    project_name: str,
    placement_name: str,
    device_id: str,
    device_template_name: str,
) -> Dict:
    r"""
    **Autogenerated function**

    Associates a physical device with a placement.

    Args:
        project_name(str): The name of the project containing the placement in which to associate the device.
        placement_name(str): The name of the placement in which to associate the device.
        device_id(str): The ID of the physical device to be associated with the given placement in the project. Note that a mandatory 4 character prefix is required for all deviceId values.
        device_template_name(str): The device template name to associate with the device ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot1click_project.device.with_placement.associate(
                ctx,
                project_name=value,
                placement_name=value,
                device_id=value,
                device_template_name=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot1click_project.device.with_placement.associate project_name=value, placement_name=value, device_id=value, device_template_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot1click-projects",
        operation="associate_device_with_placement",
        op_kwargs={
            "projectName": project_name,
            "placementName": placement_name,
            "deviceId": device_id,
            "deviceTemplateName": device_template_name,
        },
    )
