"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, project_name: str, placement_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns an object enumerating the devices in a placement.

    Args:
        project_name(str): The name of the project containing the placement.
        placement_name(str): The name of the placement to get the devices from.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot1click_project.device.in_placement.get(
                ctx, project_name=value, placement_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot1click_project.device.in_placement.get project_name=value, placement_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot1click-projects",
        operation="get_devices_in_placement",
        op_kwargs={"projectName": project_name, "placementName": placement_name},
    )
