"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def disassociate(
    hub, ctx, project_name: str, placement_name: str, device_template_name: str
) -> Dict:
    r"""
    **Autogenerated function**

    Removes a physical device from a placement.

    Args:
        project_name(str): The name of the project that contains the placement.
        placement_name(str): The name of the placement that the device should be removed from.
        device_template_name(str): The device ID that should be removed from the placement.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot1click_project.device.from_placement.disassociate(
                ctx, project_name=value, placement_name=value, device_template_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot1click_project.device.from_placement.disassociate project_name=value, placement_name=value, device_template_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot1click-projects",
        operation="disassociate_device_from_placement",
        op_kwargs={
            "projectName": project_name,
            "placementName": placement_name,
            "deviceTemplateName": device_template_name,
        },
    )
