"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def tag(hub, ctx, resource_arn: str, tags: Dict) -> None:
    r"""
        **Autogenerated function**

        Adds or updates the tags associated with the resource ARN. See AWS IoT 1-Click Service Limits for the maximum number of tags allowed per
         resource.

        Args:
            resource_arn(str): The ARN of the resource.
            tags(Dict): A collection of key/value pairs defining the resource tags. For example, {
     "tags": {"key1": "value1", "key2": "value2"} }. For more information, see AWS
     Tagging Strategies.
    .
        Examples:
            Call from code:

            .. code-block:: python

                await hub.exec.aws_auto.iot1click_device.resource.tag(
                    ctx, resource_arn=value, tags=value
                )

            Call from CLI:

            .. code-block:: bash

                $ idem exec aws_auto.iot1click_device.resource.tag resource_arn=value, tags=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot1click-devices",
        operation="tag_resource",
        op_kwargs={"ResourceArn": resource_arn, "Tags": tags},
    )


async def untag(hub, ctx, resource_arn: str, tag_keys: List) -> None:
    r"""
    **Autogenerated function**

    Using tag keys, deletes the tags (key/value pairs) associated with the specified
     resource ARN.

    Args:
        resource_arn(str): The ARN of the resource.
        tag_keys(List): A collections of tag keys. For example, {"key1","key2"}.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot1click_device.resource.untag(
                ctx, resource_arn=value, tag_keys=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot1click_device.resource.untag resource_arn=value, tag_keys=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot1click-devices",
        operation="untag_resource",
        op_kwargs={"ResourceArn": resource_arn, "TagKeys": tag_keys},
    )
