"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def update(hub, ctx, device_id: str, enabled: bool = None) -> Dict:
    r"""
       **Autogenerated function**

       Using a Boolean value (true or false), this operation
        enables or disables the device given a device ID.

       Args:
           device_id(str): The unique identifier of the device.
           enabled(bool, optional): If true, the device is enabled. If false, the device is
    disabled. Defaults to None.

       Returns:
           Dict

       Examples:
           Call from code:

           .. code-block:: python

               await hub.exec.aws_auto.iot1click_device.device.state.update(ctx, device_id=value)

           Call from CLI:

           .. code-block:: bash

               $ idem exec aws_auto.iot1click_device.device.state.update device_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot1click-devices",
        operation="update_device_state",
        op_kwargs={"DeviceId": device_id, "Enabled": enabled},
    )
