"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(hub, ctx, device_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Given a device ID, returns the invokable methods associated with the device.

    Args:
        device_id(str): The unique identifier of the device.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot1click_device.device.method.get_all(ctx, device_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot1click_device.device.method.get_all device_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot1click-devices",
        operation="get_device_methods",
        op_kwargs={"DeviceId": device_id},
    )


async def invoke(
    hub,
    ctx,
    device_id: str,
    device_method: Dict = None,
    device_method_parameters: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Given a device ID, issues a request to invoke a named device method (with possible
     parameters). See the "Example POST" code snippet below.

    Args:
        device_id(str): The unique identifier of the device.
        device_method(Dict, optional): The device method to invoke. Defaults to None.
        device_method_parameters(str, optional): A JSON encoded string containing the device method request parameters. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot1click_device.device.method.invoke(ctx, device_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot1click_device.device.method.invoke device_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot1click-devices",
        operation="invoke_device_method",
        op_kwargs={
            "DeviceId": device_id,
            "DeviceMethod": device_method,
            "DeviceMethodParameters": device_method_parameters,
        },
    )
