"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx, device_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Given a device ID, returns a DescribeDeviceResponse object describing the
     details of the device.

    Args:
        device_id(str): The unique identifier of the device.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot1click_device.device.init.describe(ctx, device_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot1click_device.device.init.describe device_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot1click-devices",
        operation="describe_device",
        op_kwargs={"DeviceId": device_id},
    )


async def list_all(
    hub, ctx, device_type: str = None, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
       **Autogenerated function**

       Lists the 1-Click compatible devices associated with your AWS account.

       Args:
           device_type(str, optional): The type of the device, such as "button". Defaults to None.
           max_results(int, optional): The maximum number of results to return per request. If not set, a default value of
    100 is used. Defaults to None.
           next_token(str, optional): The token to retrieve the next set of results. Defaults to None.

       Returns:
           Dict

       Examples:
           Call from code:

           .. code-block:: python

               await hub.exec.aws_auto.iot1click_device.device.init.list_all(ctx)

           Call from CLI:

           .. code-block:: bash

               $ idem exec aws_auto.iot1click_device.device.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot1click-devices",
        operation="list_devices",
        op_kwargs={
            "DeviceType": device_type,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def unclaim(hub, ctx, device_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Disassociates a device from your AWS account using its device ID.

    Args:
        device_id(str): The unique identifier of the device.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot1click_device.device.init.unclaim(ctx, device_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot1click_device.device.init.unclaim device_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot1click-devices",
        operation="unclaim_device",
        op_kwargs={"DeviceId": device_id},
    )
