"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub,
    ctx,
    device_id: str,
    from_time_stamp: str,
    to_time_stamp: str,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
       **Autogenerated function**

       Using a device ID, returns a DeviceEventsResponse object containing an
        array of events for the device.

       Args:
           device_id(str): The unique identifier of the device.
           from_time_stamp(str): The start date for the device event query, in ISO8061 format. For example,
    2018-03-28T15:45:12.880Z
    .
           max_results(int, optional): The maximum number of results to return per request. If not set, a default value of
    100 is used. Defaults to None.
           next_token(str, optional): The token to retrieve the next set of results. Defaults to None.
           to_time_stamp(str): The end date for the device event query, in ISO8061 format. For example,
    2018-03-28T15:45:12.880Z
    .

       Returns:
           Dict

       Examples:
           Call from code:

           .. code-block:: python

               await hub.exec.aws_auto.iot1click_device.device.event.list_all(
                   ctx, device_id=value, from_time_stamp=value, to_time_stamp=value
               )

           Call from CLI:

           .. code-block:: bash

               $ idem exec aws_auto.iot1click_device.device.event.list_all device_id=value, from_time_stamp=value, to_time_stamp=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot1click-devices",
        operation="list_device_events",
        op_kwargs={
            "DeviceId": device_id,
            "FromTimeStamp": from_time_stamp,
            "MaxResults": max_results,
            "NextToken": next_token,
            "ToTimeStamp": to_time_stamp,
        },
    )
