"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def finalize(hub, ctx, device_id: str, tags: Dict = None) -> Dict:
    r"""
        **Autogenerated function**

        Given a device ID, finalizes the claim request for the associated device.
        Claiming a device consists of initiating a claim, then publishing a device event,
         and finalizing the claim. For a device of type button, a device event can
         be published by simply clicking the device.


        Args:
            device_id(str): The unique identifier of the device.
            tags(Dict, optional): A collection of key/value pairs defining the resource tags. For example, {
     "tags": {"key1": "value1", "key2": "value2"} }. For more information, see AWS
     Tagging Strategies.
    . Defaults to None.

        Returns:
            Dict

        Examples:
            Call from code:

            .. code-block:: python

                await hub.exec.aws_auto.iot1click_device.device.claim.finalize(ctx, device_id=value)

            Call from CLI:

            .. code-block:: bash

                $ idem exec aws_auto.iot1click_device.device.claim.finalize device_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot1click-devices",
        operation="finalize_device_claim",
        op_kwargs={"DeviceId": device_id, "Tags": tags},
    )


async def initiate(hub, ctx, device_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Given a device ID, initiates a claim request for the associated device.
    Claiming a device consists of initiating a claim, then publishing a device event,
     and finalizing the claim. For a device of type button, a device event can
     be published by simply clicking the device.


    Args:
        device_id(str): The unique identifier of the device.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot1click_device.device.claim.initiate(ctx, device_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot1click_device.device.claim.initiate device_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot1click-devices",
        operation="initiate_device_claim",
        op_kwargs={"DeviceId": device_id},
    )
