"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def claim(hub, ctx, claim_code: str) -> Dict:
    r"""
    **Autogenerated function**

    Adds device(s) to your account (i.e., claim one or more devices) if and only if you
     received a claim code with the device(s).

    Args:
        claim_code(str): The claim code, starting with "C-", as provided by the device manufacturer.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot1click_device.device.by_claim_code.claim(
                ctx, claim_code=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot1click_device.device.by_claim_code.claim claim_code=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot1click-devices",
        operation="claim_devices_by_claim_code",
        op_kwargs={"ClaimCode": claim_code},
    )
