"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub,
    ctx,
    start_time: str,
    end_time: str,
    thing_name: str = None,
    security_profile_name: str = None,
    behavior_criteria_type: str = None,
    list_suppressed_alerts: bool = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the Device Defender security profile violations discovered during the given time period. You can use filters to limit the results to those alerts issued for a particular security profile, behavior, or thing (device).

    Args:
        start_time(str): The start time for the alerts to be listed.
        end_time(str): The end time for the alerts to be listed.
        thing_name(str, optional): A filter to limit results to those alerts caused by the specified thing. Defaults to None.
        security_profile_name(str, optional): A filter to limit results to those alerts generated by the specified security profile. Defaults to None.
        behavior_criteria_type(str, optional):  The criteria for a behavior. . Defaults to None.
        list_suppressed_alerts(bool, optional):  A list of all suppressed alerts. . Defaults to None.
        next_token(str, optional): The token for the next set of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return at one time. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.violation_event.list_all(
                ctx, start_time=value, end_time=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.violation_event.list_all start_time=value, end_time=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="list_violation_events",
        op_kwargs={
            "startTime": start_time,
            "endTime": end_time,
            "thingName": thing_name,
            "securityProfileName": security_profile_name,
            "behaviorCriteriaType": behavior_criteria_type,
            "listSuppressedAlerts": list_suppressed_alerts,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )
