"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"set_": "set"}


async def get_all(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Gets the fine grained logging options.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.v2_logging.option.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.v2_logging.option.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="iot", operation="get_v2_logging_options", op_kwargs={}
    )


async def set_(
    hub,
    ctx,
    role_arn: str = None,
    default_log_level: str = None,
    disable_all_logs: bool = None,
) -> None:
    r"""
    **Autogenerated function**

    Sets the logging options for the V2 logging service.

    Args:
        role_arn(str, optional): The ARN of the role that allows IoT to write to Cloudwatch logs. Defaults to None.
        default_log_level(str, optional): The default logging level. Defaults to None.
        disable_all_logs(bool, optional): If true all logs are disabled. The default is false. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.v2_logging.option.set(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.v2_logging.option.set
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="set_v2_logging_options",
        op_kwargs={
            "roleArn": role_arn,
            "defaultLogLevel": default_log_level,
            "disableAllLogs": disable_all_logs,
        },
    )
