"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"set_": "set"}


async def delete(hub, ctx, target_type: str, target_name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes a logging level.

    Args:
        target_type(str): The type of resource for which you are configuring logging. Must be THING_Group.
        target_name(str): The name of the resource for which you are configuring logging.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.v2_logging.level.delete(
                ctx, target_type=value, target_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.v2_logging.level.delete target_type=value, target_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="delete_v2_logging_level",
        op_kwargs={"targetType": target_type, "targetName": target_name},
    )


async def list_all(
    hub, ctx, target_type: str = None, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists logging levels.

    Args:
        target_type(str, optional): The type of resource for which you are configuring logging. Must be THING_Group. Defaults to None.
        next_token(str, optional): To retrieve the next set of results, the nextToken value from a previous response; otherwise null to receive the first set of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return at one time. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.v2_logging.level.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.v2_logging.level.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="list_v2_logging_levels",
        op_kwargs={
            "targetType": target_type,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )


async def set_(hub, ctx, log_target: Dict, log_level: str) -> None:
    r"""
    **Autogenerated function**

    Sets the logging level.

    Args:
        log_target(Dict): The log target.
        log_level(str): The log level.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.v2_logging.level.set(ctx, log_target=value, log_level=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.v2_logging.level.set log_target=value, log_level=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="set_v2_logging_level",
        op_kwargs={"logTarget": log_target, "logLevel": log_level},
    )
