"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub, ctx, rule_name: str, topic_rule_payload: Dict, tags: str = None
) -> None:
    r"""
    **Autogenerated function**

    Creates a rule. Creating rules is an administrator-level action. Any user who has permission to create rules will be able to access data processed by the rule.

    Args:
        rule_name(str): The name of the rule.
        topic_rule_payload(Dict): The rule payload.
        tags(str, optional): Metadata which can be used to manage the topic rule.  For URI Request parameters use format: ...key1=value1&key2=value2... For the CLI command-line parameter use format: --tags "key1=value1&key2=value2..." For the cli-input-json file use format: "tags": "key1=value1&key2=value2..." . Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.topic_rule.init.create(
                ctx, rule_name=value, topic_rule_payload=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.topic_rule.init.create rule_name=value, topic_rule_payload=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="create_topic_rule",
        op_kwargs={
            "ruleName": rule_name,
            "topicRulePayload": topic_rule_payload,
            "tags": tags,
        },
    )


async def delete(hub, ctx, rule_name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes the rule.

    Args:
        rule_name(str): The name of the rule.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.topic_rule.init.delete(ctx, rule_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.topic_rule.init.delete rule_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="delete_topic_rule",
        op_kwargs={"ruleName": rule_name},
    )


async def disable(hub, ctx, rule_name: str) -> None:
    r"""
    **Autogenerated function**

    Disables the rule.

    Args:
        rule_name(str): The name of the rule to disable.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.topic_rule.init.disable(ctx, rule_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.topic_rule.init.disable rule_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="disable_topic_rule",
        op_kwargs={"ruleName": rule_name},
    )


async def enable(hub, ctx, rule_name: str) -> None:
    r"""
    **Autogenerated function**

    Enables the rule.

    Args:
        rule_name(str): The name of the topic rule to enable.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.topic_rule.init.enable(ctx, rule_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.topic_rule.init.enable rule_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="enable_topic_rule",
        op_kwargs={"ruleName": rule_name},
    )


async def get(hub, ctx, rule_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about the rule.

    Args:
        rule_name(str): The name of the rule.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.topic_rule.init.get(ctx, rule_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.topic_rule.init.get rule_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="get_topic_rule",
        op_kwargs={"ruleName": rule_name},
    )


async def list_all(
    hub,
    ctx,
    topic: str = None,
    max_results: int = None,
    next_token: str = None,
    rule_disabled: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the rules for the specific topic.

    Args:
        topic(str, optional): The topic. Defaults to None.
        max_results(int, optional): The maximum number of results to return. Defaults to None.
        next_token(str, optional): To retrieve the next set of results, the nextToken value from a previous response; otherwise null to receive the first set of results. Defaults to None.
        rule_disabled(bool, optional): Specifies whether the rule is disabled. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.topic_rule.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.topic_rule.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="list_topic_rules",
        op_kwargs={
            "topic": topic,
            "maxResults": max_results,
            "nextToken": next_token,
            "ruleDisabled": rule_disabled,
        },
    )


async def replace(hub, ctx, rule_name: str, topic_rule_payload: Dict) -> None:
    r"""
    **Autogenerated function**

    Replaces the rule. You must specify all parameters for the new rule. Creating rules is an administrator-level action. Any user who has permission to create rules will be able to access data processed by the rule.

    Args:
        rule_name(str): The name of the rule.
        topic_rule_payload(Dict): The rule payload.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.topic_rule.init.replace(
                ctx, rule_name=value, topic_rule_payload=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.topic_rule.init.replace rule_name=value, topic_rule_payload=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="replace_topic_rule",
        op_kwargs={"ruleName": rule_name, "topicRulePayload": topic_rule_payload},
    )
