"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def confirm(hub, ctx, confirmation_token: str) -> Dict:
    r"""
    **Autogenerated function**

    Confirms a topic rule destination. When you create a rule requiring a destination, AWS IoT sends a confirmation message to the endpoint or base address you specify. The message includes a token which you pass back when calling ConfirmTopicRuleDestination to confirm that you own or have access to the endpoint.

    Args:
        confirmation_token(str): The token used to confirm ownership or access to the topic rule confirmation URL.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.topic_rule.destination.confirm(
                ctx, confirmation_token=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.topic_rule.destination.confirm confirmation_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="confirm_topic_rule_destination",
        op_kwargs={"confirmationToken": confirmation_token},
    )


async def create(hub, ctx, destination_configuration: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Creates a topic rule destination. The destination must be confirmed prior to use.

    Args:
        destination_configuration(Dict): The topic rule destination configuration.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.topic_rule.destination.create(
                ctx, destination_configuration=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.topic_rule.destination.create destination_configuration=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="create_topic_rule_destination",
        op_kwargs={"destinationConfiguration": destination_configuration},
    )


async def delete(hub, ctx, arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a topic rule destination.

    Args:
        arn(str): The ARN of the topic rule destination to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.topic_rule.destination.delete(ctx, arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.topic_rule.destination.delete arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="delete_topic_rule_destination",
        op_kwargs={"arn": arn},
    )


async def get(hub, ctx, arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about a topic rule destination.

    Args:
        arn(str): The ARN of the topic rule destination.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.topic_rule.destination.get(ctx, arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.topic_rule.destination.get arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="get_topic_rule_destination",
        op_kwargs={"arn": arn},
    )


async def list_all(hub, ctx, max_results: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists all the topic rule destinations in your AWS account.

    Args:
        max_results(int, optional): The maximum number of results to return at one time. Defaults to None.
        next_token(str, optional): To retrieve the next set of results, the nextToken value from a previous response; otherwise null to receive the first set of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.topic_rule.destination.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.topic_rule.destination.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="list_topic_rule_destinations",
        op_kwargs={"maxResults": max_results, "nextToken": next_token},
    )


async def update(hub, ctx, arn: str, status: str) -> Dict:
    r"""
    **Autogenerated function**

    Updates a topic rule destination. You use this to change the status, endpoint URL, or confirmation URL of the destination.

    Args:
        arn(str): The ARN of the topic rule destination.
        status(str): The status of the topic rule destination. Valid values are:  IN_PROGRESS  A topic rule destination was created but has not been confirmed. You can set status to IN_PROGRESS by calling UpdateTopicRuleDestination. Calling UpdateTopicRuleDestination causes a new confirmation challenge to be sent to your confirmation endpoint.  ENABLED  Confirmation was completed, and traffic to this destination is allowed. You can set status to DISABLED by calling UpdateTopicRuleDestination.  DISABLED  Confirmation was completed, and traffic to this destination is not allowed. You can set status to ENABLED by calling UpdateTopicRuleDestination.  ERROR  Confirmation could not be completed, for example if the confirmation timed out. You can call GetTopicRuleDestination for details about the error. You can set status to IN_PROGRESS by calling UpdateTopicRuleDestination. Calling UpdateTopicRuleDestination causes a new confirmation challenge to be sent to your confirmation endpoint.  .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.topic_rule.destination.update(ctx, arn=value, status=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.topic_rule.destination.update arn=value, status=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="update_topic_rule_destination",
        op_kwargs={"arn": arn, "status": status},
    )
