"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


__virtualname__ = "type"


async def create(
    hub,
    ctx,
    thing_type_name: str,
    thing_type_properties: Dict = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new thing type.

    Args:
        thing_type_name(str): The name of the thing type.
        thing_type_properties(Dict, optional): The ThingTypeProperties for the thing type to create. It contains information about the new thing type including a description, and a list of searchable thing attribute names. Defaults to None.
        tags(List, optional): Metadata which can be used to manage the thing type. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.thing.type_.create(ctx, thing_type_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.thing.type.create thing_type_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="create_thing_type",
        op_kwargs={
            "thingTypeName": thing_type_name,
            "thingTypeProperties": thing_type_properties,
            "tags": tags,
        },
    )


async def delete(hub, ctx, thing_type_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified thing type. You cannot delete a thing type if it has things associated with it. To delete a thing type, first mark it as deprecated by calling DeprecateThingType, then remove any associated things by calling UpdateThing to change the thing type on any associated thing, and finally use DeleteThingType to delete the thing type.

    Args:
        thing_type_name(str): The name of the thing type.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.thing.type_.delete(ctx, thing_type_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.thing.type.delete thing_type_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="delete_thing_type",
        op_kwargs={"thingTypeName": thing_type_name},
    )


async def deprecate(
    hub, ctx, thing_type_name: str, undo_deprecate: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Deprecates a thing type. You can not associate new things with deprecated thing type.

    Args:
        thing_type_name(str): The name of the thing type to deprecate.
        undo_deprecate(bool, optional): Whether to undeprecate a deprecated thing type. If true, the thing type will not be deprecated anymore and you can associate it with things. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.thing.type_.deprecate(ctx, thing_type_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.thing.type.deprecate thing_type_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="deprecate_thing_type",
        op_kwargs={"thingTypeName": thing_type_name, "undoDeprecate": undo_deprecate},
    )


async def describe(hub, ctx, thing_type_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about the specified thing type.

    Args:
        thing_type_name(str): The name of the thing type.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.thing.type_.describe(ctx, thing_type_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.thing.type.describe thing_type_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="describe_thing_type",
        op_kwargs={"thingTypeName": thing_type_name},
    )


async def list_all(
    hub,
    ctx,
    next_token: str = None,
    max_results: int = None,
    thing_type_name: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the existing thing types.

    Args:
        next_token(str, optional): To retrieve the next set of results, the nextToken value from a previous response; otherwise null to receive the first set of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return in this operation. Defaults to None.
        thing_type_name(str, optional): The name of the thing type. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.thing.type_.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.thing.type.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="list_thing_types",
        op_kwargs={
            "nextToken": next_token,
            "maxResults": max_results,
            "thingTypeName": thing_type_name,
        },
    )
