"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def add(
    hub,
    ctx,
    thing_group_name: str = None,
    thing_group_arn: str = None,
    thing_name: str = None,
    thing_arn: str = None,
    override_dynamic_groups: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Adds a thing to a thing group.

    Args:
        thing_group_name(str, optional): The name of the group to which you are adding a thing. Defaults to None.
        thing_group_arn(str, optional): The ARN of the group to which you are adding a thing. Defaults to None.
        thing_name(str, optional): The name of the thing to add to a group. Defaults to None.
        thing_arn(str, optional): The ARN of the thing to add to a group. Defaults to None.
        override_dynamic_groups(bool, optional): Override dynamic thing groups with static thing groups when 10-group limit is reached. If a thing belongs to 10 thing groups, and one or more of those groups are dynamic thing groups, adding a thing to a static group removes the thing from the last dynamic group. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.thing.to.thing_group.add(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.thing.to.thing_group.add
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="add_thing_to_thing_group",
        op_kwargs={
            "thingGroupName": thing_group_name,
            "thingGroupArn": thing_group_arn,
            "thingName": thing_name,
            "thingArn": thing_arn,
            "overrideDynamicGroups": override_dynamic_groups,
        },
    )
