"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def attach(hub, ctx, thing_name: str, principal: str) -> Dict:
    r"""
    **Autogenerated function**

    Attaches the specified principal to the specified thing. A principal can be X.509 certificates, IAM users, groups, and roles, Amazon Cognito identities or federated identities.

    Args:
        thing_name(str): The name of the thing.
        principal(str): The principal, which can be a certificate ARN (as returned from the CreateCertificate operation) or an Amazon Cognito ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.thing.principal.attach(
                ctx, thing_name=value, principal=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.thing.principal.attach thing_name=value, principal=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="attach_thing_principal",
        op_kwargs={"thingName": thing_name, "principal": principal},
    )


async def detach(hub, ctx, thing_name: str, principal: str) -> Dict:
    r"""
    **Autogenerated function**

    Detaches the specified principal from the specified thing. A principal can be X.509 certificates, IAM users, groups, and roles, Amazon Cognito identities or federated identities.  This call is asynchronous. It might take several seconds for the detachment to propagate.

    Args:
        thing_name(str): The name of the thing.
        principal(str): If the principal is a certificate, this value must be ARN of the certificate. If the principal is an Amazon Cognito identity, this value must be the ID of the Amazon Cognito identity.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.thing.principal.detach(
                ctx, thing_name=value, principal=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.thing.principal.detach thing_name=value, principal=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="detach_thing_principal",
        op_kwargs={"thingName": thing_name, "principal": principal},
    )


async def list_all(
    hub, ctx, thing_name: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the principals associated with the specified thing. A principal can be X.509 certificates, IAM users, groups, and roles, Amazon Cognito identities or federated identities.

    Args:
        next_token(str, optional): To retrieve the next set of results, the nextToken value from a previous response; otherwise null to receive the first set of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return in this operation. Defaults to None.
        thing_name(str): The name of the thing.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.thing.principal.list_all(ctx, thing_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.thing.principal.list_all thing_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="list_thing_principals",
        op_kwargs={
            "nextToken": next_token,
            "maxResults": max_results,
            "thingName": thing_name,
        },
    )
