"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    thing_name: str,
    thing_type_name: str = None,
    attribute_payload: Dict = None,
    billing_group_name: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a thing record in the registry. If this call is made multiple times using the same thing name and configuration, the call will succeed. If this call is made with the same thing name but different configuration a ResourceAlreadyExistsException is thrown.  This is a control plane operation. See Authorization for information about authorizing control plane actions.

    Args:
        thing_name(str): The name of the thing to create. You can't change a thing's name after you create it. To change a thing's name, you must create a new thing, give it the new name, and then delete the old thing.
        thing_type_name(str, optional): The name of the thing type associated with the new thing. Defaults to None.
        attribute_payload(Dict, optional): The attribute payload, which consists of up to three name/value pairs in a JSON document. For example:  {\"attributes\":{\"string1\":\"string2\"}} . Defaults to None.
        billing_group_name(str, optional): The name of the billing group the thing will be added to. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.thing.init.create(ctx, thing_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.thing.init.create thing_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="create_thing",
        op_kwargs={
            "thingName": thing_name,
            "thingTypeName": thing_type_name,
            "attributePayload": attribute_payload,
            "billingGroupName": billing_group_name,
        },
    )


async def delete(hub, ctx, thing_name: str, expected_version: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified thing. Returns successfully with no error if the deletion is successful or you specify a thing that doesn't exist.

    Args:
        thing_name(str): The name of the thing to delete.
        expected_version(int, optional): The expected version of the thing record in the registry. If the version of the record in the registry does not match the expected version specified in the request, the DeleteThing request is rejected with a VersionConflictException. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.thing.init.delete(ctx, thing_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.thing.init.delete thing_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="delete_thing",
        op_kwargs={"thingName": thing_name, "expectedVersion": expected_version},
    )


async def describe(hub, ctx, thing_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about the specified thing.

    Args:
        thing_name(str): The name of the thing.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.thing.init.describe(ctx, thing_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.thing.init.describe thing_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="describe_thing",
        op_kwargs={"thingName": thing_name},
    )


async def list_all(
    hub,
    ctx,
    next_token: str = None,
    max_results: int = None,
    attribute_name: str = None,
    attribute_value: str = None,
    thing_type_name: str = None,
    use_prefix_attribute_value: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists your things. Use the attributeName and attributeValue parameters to filter your things. For example, calling ListThings with attributeName=Color and attributeValue=Red retrieves all things in the registry that contain an attribute Color with the value Red.   You will not be charged for calling this API if an Access denied error is returned. You will also not be charged if no attributes or pagination token was provided in request and no pagination token and no results were returned.

    Args:
        next_token(str, optional): To retrieve the next set of results, the nextToken value from a previous response; otherwise null to receive the first set of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return in this operation. Defaults to None.
        attribute_name(str, optional): The attribute name used to search for things. Defaults to None.
        attribute_value(str, optional): The attribute value used to search for things. Defaults to None.
        thing_type_name(str, optional): The name of the thing type used to search for things. Defaults to None.
        use_prefix_attribute_value(bool, optional): When true, the action returns the thing resources with attribute values that start with the attributeValue provided. When false, or not present, the action returns only the thing resources with attribute values that match the entire attributeValue provided. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.thing.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.thing.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="list_things",
        op_kwargs={
            "nextToken": next_token,
            "maxResults": max_results,
            "attributeName": attribute_name,
            "attributeValue": attribute_value,
            "thingTypeName": thing_type_name,
            "usePrefixAttributeValue": use_prefix_attribute_value,
        },
    )


async def register(hub, ctx, template_body: str, parameters: Dict = None) -> Dict:
    r"""
    **Autogenerated function**

    Provisions a thing in the device registry. RegisterThing calls other AWS IoT control plane APIs. These calls might exceed your account level  AWS IoT Throttling Limits and cause throttle errors. Please contact AWS Customer Support to raise your throttling limits if necessary.

    Args:
        template_body(str): The provisioning template. See Provisioning Devices That Have Device Certificates for more information.
        parameters(Dict, optional): The parameters for provisioning a thing. See Provisioning Templates for more information. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.thing.init.register(ctx, template_body=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.thing.init.register template_body=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="register_thing",
        op_kwargs={"templateBody": template_body, "parameters": parameters},
    )


async def update(
    hub,
    ctx,
    thing_name: str,
    thing_type_name: str = None,
    attribute_payload: Dict = None,
    expected_version: int = None,
    remove_thing_type: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the data for a thing.

    Args:
        thing_name(str): The name of the thing to update. You can't change a thing's name. To change a thing's name, you must create a new thing, give it the new name, and then delete the old thing.
        thing_type_name(str, optional): The name of the thing type. Defaults to None.
        attribute_payload(Dict, optional): A list of thing attributes, a JSON string containing name-value pairs. For example:  {\"attributes\":{\"name1\":\"value2\"}}  This data is used to add new attributes or update existing attributes. Defaults to None.
        expected_version(int, optional): The expected version of the thing record in the registry. If the version of the record in the registry does not match the expected version specified in the request, the UpdateThing request is rejected with a VersionConflictException. Defaults to None.
        remove_thing_type(bool, optional): Remove a thing type association. If true, the association is removed. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.thing.init.update(ctx, thing_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.thing.init.update thing_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="update_thing",
        op_kwargs={
            "thingName": thing_name,
            "thingTypeName": thing_type_name,
            "attributePayload": attribute_payload,
            "expectedVersion": expected_version,
            "removeThingType": remove_thing_type,
        },
    )
