"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


__func_alias__ = {"list_": "list"}


async def list_(
    hub, ctx, thing_name: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    List the thing groups to which the specified thing belongs.

    Args:
        thing_name(str): The thing name.
        next_token(str, optional): To retrieve the next set of results, the nextToken value from a previous response; otherwise null to receive the first set of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return at one time. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.thing.group.for_thing.list(ctx, thing_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.thing.group.for_thing.list thing_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="list_thing_groups_for_thing",
        op_kwargs={
            "thingName": thing_name,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )


async def update(
    hub,
    ctx,
    thing_name: str = None,
    thing_groups_to_add: List = None,
    thing_groups_to_remove: List = None,
    override_dynamic_groups: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the groups to which the thing belongs.

    Args:
        thing_name(str, optional): The thing whose group memberships will be updated. Defaults to None.
        thing_groups_to_add(List, optional): The groups to which the thing will be added. Defaults to None.
        thing_groups_to_remove(List, optional): The groups from which the thing will be removed. Defaults to None.
        override_dynamic_groups(bool, optional): Override dynamic thing groups with static thing groups when 10-group limit is reached. If a thing belongs to 10 thing groups, and one or more of those groups are dynamic thing groups, adding a thing to a static group removes the thing from the last dynamic group. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.thing.group.for_thing.update(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.thing.group.for_thing.update
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="update_thing_groups_for_thing",
        op_kwargs={
            "thingName": thing_name,
            "thingGroupsToAdd": thing_groups_to_add,
            "thingGroupsToRemove": thing_groups_to_remove,
            "overrideDynamicGroups": override_dynamic_groups,
        },
    )
