"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def remove(
    hub,
    ctx,
    thing_group_name: str = None,
    thing_group_arn: str = None,
    thing_name: str = None,
    thing_arn: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Remove the specified thing from the specified group. You must specify either a thingGroupArn or a thingGroupName to identify the thing group and either a thingArn or a thingName to identify the thing to remove from the thing group.

    Args:
        thing_group_name(str, optional): The group name. Defaults to None.
        thing_group_arn(str, optional): The group ARN. Defaults to None.
        thing_name(str, optional): The name of the thing to remove from the group. Defaults to None.
        thing_arn(str, optional): The ARN of the thing to remove from the group. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.thing.from_.thing_group.remove(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.thing.from_.thing_group.remove
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="remove_thing_from_thing_group",
        op_kwargs={
            "thingGroupName": thing_group_name,
            "thingGroupArn": thing_group_arn,
            "thingName": thing_name,
            "thingArn": thing_arn,
        },
    )
