"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def remove(
    hub,
    ctx,
    billing_group_name: str = None,
    billing_group_arn: str = None,
    thing_name: str = None,
    thing_arn: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Removes the given thing from the billing group.

    Args:
        billing_group_name(str, optional): The name of the billing group. Defaults to None.
        billing_group_arn(str, optional): The ARN of the billing group. Defaults to None.
        thing_name(str, optional): The name of the thing to be removed from the billing group. Defaults to None.
        thing_arn(str, optional): The ARN of the thing to be removed from the billing group. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.thing.from_.billing_group.remove(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.thing.from_.billing_group.remove
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="remove_thing_from_billing_group",
        op_kwargs={
            "billingGroupName": billing_group_name,
            "billingGroupArn": billing_group_arn,
            "thingName": thing_name,
            "thingArn": thing_arn,
        },
    )
