"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def associate(
    hub, ctx, targets: List, job_id: str, comment: str = None, namespace_id: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Associates a group with a continuous job. The following criteria must be met:    The job must have been created with the targetSelection field set to "CONTINUOUS".   The job status must currently be "IN_PROGRESS".   The total number of targets associated with a job must not exceed 100.

    Args:
        targets(List): A list of thing group ARNs that define the targets of the job.
        job_id(str): The unique identifier you assigned to this job when it was created.
        comment(str, optional): An optional comment string describing why the job was associated with the targets. Defaults to None.
        namespace_id(str, optional): The namespace used to indicate that a job is a customer-managed job. When you specify a value for this parameter, AWS IoT Core sends jobs notifications to MQTT topics that contain the value in the following format.  $aws/things/THING_NAME/jobs/JOB_ID/notify-namespace-NAMESPACE_ID/   The namespaceId feature is in public preview. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.target.with_job.associate(ctx, targets=value, job_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.target.with_job.associate targets=value, job_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="associate_targets_with_job",
        op_kwargs={
            "targets": targets,
            "jobId": job_id,
            "comment": comment,
            "namespaceId": namespace_id,
        },
    )
