"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(
    hub,
    ctx,
    security_profile_name: str,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the targets (thing groups) associated with a given Device Defender security profile.

    Args:
        security_profile_name(str): The security profile.
        next_token(str, optional): The token for the next set of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return at one time. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.target.for_.security_profile.list(
                ctx, security_profile_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.target.for_.security_profile.list security_profile_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="list_targets_for_security_profile",
        op_kwargs={
            "securityProfileName": security_profile_name,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )
