"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(
    hub, ctx, policy_name: str, marker: str = None, page_size: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    List targets for the specified policy.

    Args:
        policy_name(str): The policy name.
        marker(str, optional): A marker used to get the next set of results. Defaults to None.
        page_size(int, optional): The maximum number of results to return at one time. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.target.for_.policy.list(ctx, policy_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.target.for_.policy.list policy_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="list_targets_for_policy",
        op_kwargs={"policyName": policy_name, "marker": marker, "pageSize": page_size},
    )
