"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    stream_id: str,
    files: List,
    role_arn: str,
    description: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a stream for delivering one or more large files in chunks over MQTT. A stream transports data bytes in chunks or blocks packaged as MQTT messages from a source like S3. You can have one or more files associated with a stream.

    Args:
        stream_id(str): The stream ID.
        description(str, optional): A description of the stream. Defaults to None.
        files(List): The files to stream.
        role_arn(str): An IAM role that allows the IoT service principal assumes to access your S3 files.
        tags(List, optional): Metadata which can be used to manage streams. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.stream.create(
                ctx, stream_id=value, files=value, role_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.stream.create stream_id=value, files=value, role_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="create_stream",
        op_kwargs={
            "streamId": stream_id,
            "description": description,
            "files": files,
            "roleArn": role_arn,
            "tags": tags,
        },
    )


async def delete(hub, ctx, stream_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a stream.

    Args:
        stream_id(str): The stream ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.stream.delete(ctx, stream_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.stream.delete stream_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="delete_stream",
        op_kwargs={"streamId": stream_id},
    )


async def describe(hub, ctx, stream_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about a stream.

    Args:
        stream_id(str): The stream ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.stream.describe(ctx, stream_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.stream.describe stream_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="describe_stream",
        op_kwargs={"streamId": stream_id},
    )


async def list_all(
    hub,
    ctx,
    max_results: int = None,
    next_token: str = None,
    ascending_order: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists all of the streams in your AWS account.

    Args:
        max_results(int, optional): The maximum number of results to return at a time. Defaults to None.
        next_token(str, optional): A token used to get the next set of results. Defaults to None.
        ascending_order(bool, optional): Set to true to return the list of streams in ascending order. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.stream.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.stream.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="list_streams",
        op_kwargs={
            "maxResults": max_results,
            "nextToken": next_token,
            "ascendingOrder": ascending_order,
        },
    )


async def update(
    hub,
    ctx,
    stream_id: str,
    description: str = None,
    files: List = None,
    role_arn: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates an existing stream. The stream version will be incremented by one.

    Args:
        stream_id(str): The stream ID.
        description(str, optional): The description of the stream. Defaults to None.
        files(List, optional): The files associated with the stream. Defaults to None.
        role_arn(str, optional): An IAM role that allows the IoT service principal assumes to access your S3 files. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.stream.update(ctx, stream_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.stream.update stream_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="update_stream",
        op_kwargs={
            "streamId": stream_id,
            "description": description,
            "files": files,
            "roleArn": role_arn,
        },
    )
