"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(
    hub,
    ctx,
    query_string: str,
    index_name: str = None,
    aggregation_field: str = None,
    query_version: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns the count, average, sum, minimum, maximum, sum of squares, variance, and standard deviation for the specified aggregated field. If the aggregation field is of type String, only the count statistic is returned.

    Args:
        index_name(str, optional): The name of the index to search. The default value is AWS_Things. Defaults to None.
        query_string(str): The query used to search. You can specify "*" for the query string to get the count of all indexed things in your AWS account.
        aggregation_field(str, optional): The aggregation field name. Defaults to None.
        query_version(str, optional): The version of the query used to search. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.statistic.get_all(ctx, query_string=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.statistic.get_all query_string=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="get_statistics",
        op_kwargs={
            "indexName": index_name,
            "queryString": query_string,
            "aggregationField": aggregation_field,
            "queryVersion": query_version,
        },
    )
