"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def attach(
    hub, ctx, security_profile_name: str, security_profile_target_arn: str
) -> Dict:
    r"""
    **Autogenerated function**

    Associates a Device Defender security profile with a thing group or this account. Each thing group or account can have up to five security profiles associated with it.

    Args:
        security_profile_name(str): The security profile that is attached.
        security_profile_target_arn(str): The ARN of the target (thing group) to which the security profile is attached.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.security_profile.init.attach(
                ctx, security_profile_name=value, security_profile_target_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.security_profile.init.attach security_profile_name=value, security_profile_target_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="attach_security_profile",
        op_kwargs={
            "securityProfileName": security_profile_name,
            "securityProfileTargetArn": security_profile_target_arn,
        },
    )


async def create(
    hub,
    ctx,
    security_profile_name: str,
    security_profile_description: str = None,
    behaviors: List = None,
    alert_targets: Dict = None,
    additional_metrics_to_retain: List = None,
    additional_metrics_to_retain_v2: List = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a Device Defender security profile.

    Args:
        security_profile_name(str): The name you are giving to the security profile.
        security_profile_description(str, optional): A description of the security profile. Defaults to None.
        behaviors(List, optional): Specifies the behaviors that, when violated by a device (thing), cause an alert. Defaults to None.
        alert_targets(Dict, optional): Specifies the destinations to which alerts are sent. (Alerts are always sent to the console.) Alerts are generated when a device (thing) violates a behavior. Defaults to None.
        additional_metrics_to_retain(List, optional):  Please use CreateSecurityProfileRequest$additionalMetricsToRetainV2 instead.  A list of metrics whose data is retained (stored). By default, data is retained for any metric used in the profile's behaviors, but it is also retained for any metric specified here. Can be used with custom metrics; cannot be used with dimensions. Defaults to None.
        additional_metrics_to_retain_v2(List, optional): A list of metrics whose data is retained (stored). By default, data is retained for any metric used in the profile's behaviors, but it is also retained for any metric specified here. Can be used with custom metrics; cannot be used with dimensions. Defaults to None.
        tags(List, optional): Metadata that can be used to manage the security profile. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.security_profile.init.create(
                ctx, security_profile_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.security_profile.init.create security_profile_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="create_security_profile",
        op_kwargs={
            "securityProfileName": security_profile_name,
            "securityProfileDescription": security_profile_description,
            "behaviors": behaviors,
            "alertTargets": alert_targets,
            "additionalMetricsToRetain": additional_metrics_to_retain,
            "additionalMetricsToRetainV2": additional_metrics_to_retain_v2,
            "tags": tags,
        },
    )


async def delete(
    hub, ctx, security_profile_name: str, expected_version: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a Device Defender security profile.

    Args:
        security_profile_name(str): The name of the security profile to be deleted.
        expected_version(int, optional): The expected version of the security profile. A new version is generated whenever the security profile is updated. If you specify a value that is different from the actual version, a VersionConflictException is thrown. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.security_profile.init.delete(
                ctx, security_profile_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.security_profile.init.delete security_profile_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="delete_security_profile",
        op_kwargs={
            "securityProfileName": security_profile_name,
            "expectedVersion": expected_version,
        },
    )


async def describe(hub, ctx, security_profile_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about a Device Defender security profile.

    Args:
        security_profile_name(str): The name of the security profile whose information you want to get.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.security_profile.init.describe(
                ctx, security_profile_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.security_profile.init.describe security_profile_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="describe_security_profile",
        op_kwargs={"securityProfileName": security_profile_name},
    )


async def detach(
    hub, ctx, security_profile_name: str, security_profile_target_arn: str
) -> Dict:
    r"""
    **Autogenerated function**

    Disassociates a Device Defender security profile from a thing group or from this account.

    Args:
        security_profile_name(str): The security profile that is detached.
        security_profile_target_arn(str): The ARN of the thing group from which the security profile is detached.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.security_profile.init.detach(
                ctx, security_profile_name=value, security_profile_target_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.security_profile.init.detach security_profile_name=value, security_profile_target_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="detach_security_profile",
        op_kwargs={
            "securityProfileName": security_profile_name,
            "securityProfileTargetArn": security_profile_target_arn,
        },
    )


async def list_all(
    hub,
    ctx,
    next_token: str = None,
    max_results: int = None,
    dimension_name: str = None,
    metric_name: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the Device Defender security profiles you've created. You can filter security profiles by dimension or custom metric.   dimensionName and metricName cannot be used in the same request.

    Args:
        next_token(str, optional): The token for the next set of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return at one time. Defaults to None.
        dimension_name(str, optional): A filter to limit results to the security profiles that use the defined dimension. Cannot be used with metricName . Defaults to None.
        metric_name(str, optional):  The name of the custom metric. Cannot be used with dimensionName. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.security_profile.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.security_profile.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="list_security_profiles",
        op_kwargs={
            "nextToken": next_token,
            "maxResults": max_results,
            "dimensionName": dimension_name,
            "metricName": metric_name,
        },
    )


async def update(
    hub,
    ctx,
    security_profile_name: str,
    security_profile_description: str = None,
    behaviors: List = None,
    alert_targets: Dict = None,
    additional_metrics_to_retain: List = None,
    additional_metrics_to_retain_v2: List = None,
    delete_behaviors: bool = None,
    delete_alert_targets: bool = None,
    delete_additional_metrics_to_retain: bool = None,
    expected_version: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a Device Defender security profile.

    Args:
        security_profile_name(str): The name of the security profile you want to update.
        security_profile_description(str, optional): A description of the security profile. Defaults to None.
        behaviors(List, optional): Specifies the behaviors that, when violated by a device (thing), cause an alert. Defaults to None.
        alert_targets(Dict, optional): Where the alerts are sent. (Alerts are always sent to the console.). Defaults to None.
        additional_metrics_to_retain(List, optional):  Please use UpdateSecurityProfileRequest$additionalMetricsToRetainV2 instead.  A list of metrics whose data is retained (stored). By default, data is retained for any metric used in the profile's behaviors, but it is also retained for any metric specified here. Can be used with custom metrics; cannot be used with dimensions. Defaults to None.
        additional_metrics_to_retain_v2(List, optional): A list of metrics whose data is retained (stored). By default, data is retained for any metric used in the profile's behaviors, but it is also retained for any metric specified here. Can be used with custom metrics; cannot be used with dimensions. Defaults to None.
        delete_behaviors(bool, optional): If true, delete all behaviors defined for this security profile. If any behaviors are defined in the current invocation, an exception occurs. Defaults to None.
        delete_alert_targets(bool, optional): If true, delete all alertTargets defined for this security profile. If any alertTargets are defined in the current invocation, an exception occurs. Defaults to None.
        delete_additional_metrics_to_retain(bool, optional): If true, delete all additionalMetricsToRetain defined for this security profile. If any additionalMetricsToRetain are defined in the current invocation, an exception occurs. Defaults to None.
        expected_version(int, optional): The expected version of the security profile. A new version is generated whenever the security profile is updated. If you specify a value that is different from the actual version, a VersionConflictException is thrown. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.security_profile.init.update(
                ctx, security_profile_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.security_profile.init.update security_profile_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="update_security_profile",
        op_kwargs={
            "securityProfileName": security_profile_name,
            "securityProfileDescription": security_profile_description,
            "behaviors": behaviors,
            "alertTargets": alert_targets,
            "additionalMetricsToRetain": additional_metrics_to_retain,
            "additionalMetricsToRetainV2": additional_metrics_to_retain_v2,
            "deleteBehaviors": delete_behaviors,
            "deleteAlertTargets": delete_alert_targets,
            "deleteAdditionalMetricsToRetain": delete_additional_metrics_to_retain,
            "expectedVersion": expected_version,
        },
    )
