"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(
    hub,
    ctx,
    security_profile_target_arn: str,
    next_token: str = None,
    max_results: int = None,
    recursive: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the Device Defender security profiles attached to a target (thing group).

    Args:
        next_token(str, optional): The token for the next set of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return at one time. Defaults to None.
        recursive(bool, optional): If true, return child groups too. Defaults to None.
        security_profile_target_arn(str): The ARN of the target (thing group) whose attached security profiles you want to get.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.security_profile.for_target.list(
                ctx, security_profile_target_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.security_profile.for_target.list security_profile_target_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="list_security_profiles_for_target",
        op_kwargs={
            "nextToken": next_token,
            "maxResults": max_results,
            "recursive": recursive,
            "securityProfileTargetArn": security_profile_target_arn,
        },
    )
