"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def validate(hub, ctx, behaviors: List) -> Dict:
    r"""
    **Autogenerated function**

    Validates a Device Defender security profile behaviors specification.

    Args:
        behaviors(List): Specifies the behaviors that, when violated by a device (thing), cause an alert.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.security_profile.behavior.validate(ctx, behaviors=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.security_profile.behavior.validate behaviors=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="validate_security_profile_behaviors",
        op_kwargs={"behaviors": behaviors},
    )
