"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    frequency: str,
    target_check_names: List,
    scheduled_audit_name: str,
    day_of_month: str = None,
    day_of_week: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a scheduled audit that is run at a specified time interval.

    Args:
        frequency(str): How often the scheduled audit takes place, either DAILY, WEEKLY, BIWEEKLY or MONTHLY. The start time of each audit is determined by the system.
        day_of_month(str, optional): The day of the month on which the scheduled audit takes place. This can be "1" through "31" or "LAST". This field is required if the "frequency" parameter is set to MONTHLY. If days 29 to 31 are specified, and the month doesn't have that many days, the audit takes place on the LAST day of the month. Defaults to None.
        day_of_week(str, optional): The day of the week on which the scheduled audit takes place, either SUN, MON, TUE, WED, THU, FRI, or SAT. This field is required if the frequency parameter is set to WEEKLY or BIWEEKLY. Defaults to None.
        target_check_names(List): Which checks are performed during the scheduled audit. Checks must be enabled for your account. (Use DescribeAccountAuditConfiguration to see the list of all checks, including those that are enabled or use UpdateAccountAuditConfiguration to select which checks are enabled.).
        scheduled_audit_name(str): The name you want to give to the scheduled audit. (Max. 128 chars).
        tags(List, optional): Metadata that can be used to manage the scheduled audit. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.scheduled_audit.create(
                ctx, frequency=value, target_check_names=value, scheduled_audit_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.scheduled_audit.create frequency=value, target_check_names=value, scheduled_audit_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="create_scheduled_audit",
        op_kwargs={
            "frequency": frequency,
            "dayOfMonth": day_of_month,
            "dayOfWeek": day_of_week,
            "targetCheckNames": target_check_names,
            "scheduledAuditName": scheduled_audit_name,
            "tags": tags,
        },
    )


async def delete(hub, ctx, scheduled_audit_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a scheduled audit.

    Args:
        scheduled_audit_name(str): The name of the scheduled audit you want to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.scheduled_audit.delete(ctx, scheduled_audit_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.scheduled_audit.delete scheduled_audit_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="delete_scheduled_audit",
        op_kwargs={"scheduledAuditName": scheduled_audit_name},
    )


async def describe(hub, ctx, scheduled_audit_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about a scheduled audit.

    Args:
        scheduled_audit_name(str): The name of the scheduled audit whose information you want to get.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.scheduled_audit.describe(ctx, scheduled_audit_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.scheduled_audit.describe scheduled_audit_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="describe_scheduled_audit",
        op_kwargs={"scheduledAuditName": scheduled_audit_name},
    )


async def list_all(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists all of your scheduled audits.

    Args:
        next_token(str, optional): The token for the next set of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return at one time. The default is 25. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.scheduled_audit.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.scheduled_audit.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="list_scheduled_audits",
        op_kwargs={"nextToken": next_token, "maxResults": max_results},
    )


async def update(
    hub,
    ctx,
    scheduled_audit_name: str,
    frequency: str = None,
    day_of_month: str = None,
    day_of_week: str = None,
    target_check_names: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a scheduled audit, including which checks are performed and how often the audit takes place.

    Args:
        frequency(str, optional): How often the scheduled audit takes place, either DAILY, WEEKLY, BIWEEKLY, or MONTHLY. The start time of each audit is determined by the system. Defaults to None.
        day_of_month(str, optional): The day of the month on which the scheduled audit takes place. This can be 1 through 31 or LAST. This field is required if the frequency parameter is set to MONTHLY. If days 29-31 are specified, and the month does not have that many days, the audit takes place on the "LAST" day of the month. Defaults to None.
        day_of_week(str, optional): The day of the week on which the scheduled audit takes place. This can be one of SUN, MON, TUE, WED, THU, FRI, or SAT. This field is required if the "frequency" parameter is set to WEEKLY or BIWEEKLY. Defaults to None.
        target_check_names(List, optional): Which checks are performed during the scheduled audit. Checks must be enabled for your account. (Use DescribeAccountAuditConfiguration to see the list of all checks, including those that are enabled or use UpdateAccountAuditConfiguration to select which checks are enabled.). Defaults to None.
        scheduled_audit_name(str): The name of the scheduled audit. (Max. 128 chars).

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.scheduled_audit.update(ctx, scheduled_audit_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.scheduled_audit.update scheduled_audit_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="update_scheduled_audit",
        op_kwargs={
            "frequency": frequency,
            "dayOfMonth": day_of_month,
            "dayOfWeek": day_of_week,
            "targetCheckNames": target_check_names,
            "scheduledAuditName": scheduled_audit_name,
        },
    )
