"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub, ctx, page_size: int = None, marker: str = None, ascending_order: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the role aliases registered in your account.

    Args:
        page_size(int, optional): The maximum number of results to return at one time. Defaults to None.
        marker(str, optional): A marker used to get the next set of results. Defaults to None.
        ascending_order(bool, optional): Return the list of role aliases in ascending alphabetical order. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.role_aliase.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.role_aliase.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="list_role_aliases",
        op_kwargs={
            "pageSize": page_size,
            "marker": marker,
            "ascendingOrder": ascending_order,
        },
    )
