"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    role_alias: str,
    role_arn: str,
    credential_duration_seconds: int = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a role alias.

    Args:
        role_alias(str): The role alias that points to a role ARN. This allows you to change the role without having to update the device.
        role_arn(str): The role ARN.
        credential_duration_seconds(int, optional): How long (in seconds) the credentials will be valid. Defaults to None.
        tags(List, optional): Metadata which can be used to manage the role alias.  For URI Request parameters use format: ...key1=value1&key2=value2... For the CLI command-line parameter use format: &&tags "key1=value1&key2=value2..." For the cli-input-json file use format: "tags": "key1=value1&key2=value2..." . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.role_alias.create(ctx, role_alias=value, role_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.role_alias.create role_alias=value, role_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="create_role_alias",
        op_kwargs={
            "roleAlias": role_alias,
            "roleArn": role_arn,
            "credentialDurationSeconds": credential_duration_seconds,
            "tags": tags,
        },
    )


async def delete(hub, ctx, role_alias: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a role alias

    Args:
        role_alias(str): The role alias to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.role_alias.delete(ctx, role_alias=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.role_alias.delete role_alias=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="delete_role_alias",
        op_kwargs={"roleAlias": role_alias},
    )


async def describe(hub, ctx, role_alias: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes a role alias.

    Args:
        role_alias(str): The role alias to describe.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.role_alias.describe(ctx, role_alias=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.role_alias.describe role_alias=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="describe_role_alias",
        op_kwargs={"roleAlias": role_alias},
    )


async def update(
    hub,
    ctx,
    role_alias: str,
    role_arn: str = None,
    credential_duration_seconds: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a role alias.

    Args:
        role_alias(str): The role alias to update.
        role_arn(str, optional): The role ARN. Defaults to None.
        credential_duration_seconds(int, optional): The number of seconds the credential will be valid. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.role_alias.update(ctx, role_alias=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.role_alias.update role_alias=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="update_role_alias",
        op_kwargs={
            "roleAlias": role_alias,
            "roleArn": role_arn,
            "credentialDurationSeconds": credential_duration_seconds,
        },
    )
