"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a CA certificate registration code.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.registration_code.delete(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.registration_code.delete
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="iot", operation="delete_registration_code", op_kwargs={}
    )


async def get(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Gets a registration code used to register a CA certificate with AWS IoT.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.registration_code.get(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.registration_code.get
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="iot", operation="get_registration_code", op_kwargs={}
    )
