"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub, ctx, template_name: str, template_body: str, set_as_default: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new version of a fleet provisioning template.

    Args:
        template_name(str): The name of the fleet provisioning template.
        template_body(str): The JSON formatted contents of the fleet provisioning template.
        set_as_default(bool, optional): Sets a fleet provision template version as the default version. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.provisioning.template.version.create(
                ctx, template_name=value, template_body=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.provisioning.template.version.create template_name=value, template_body=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="create_provisioning_template_version",
        op_kwargs={
            "templateName": template_name,
            "templateBody": template_body,
            "setAsDefault": set_as_default,
        },
    )


async def delete(hub, ctx, template_name: str, version_id: int) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a fleet provisioning template version.

    Args:
        template_name(str): The name of the fleet provisioning template version to delete.
        version_id(int): The fleet provisioning template version ID to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.provisioning.template.version.delete(
                ctx, template_name=value, version_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.provisioning.template.version.delete template_name=value, version_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="delete_provisioning_template_version",
        op_kwargs={"templateName": template_name, "versionId": version_id},
    )


async def describe(hub, ctx, template_name: str, version_id: int) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about a fleet provisioning template version.

    Args:
        template_name(str): The template name.
        version_id(int): The fleet provisioning template version ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.provisioning.template.version.describe(
                ctx, template_name=value, version_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.provisioning.template.version.describe template_name=value, version_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="describe_provisioning_template_version",
        op_kwargs={"templateName": template_name, "versionId": version_id},
    )


async def list_all(
    hub, ctx, template_name: str, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    A list of fleet provisioning template versions.

    Args:
        template_name(str): The name of the fleet provisioning template.
        max_results(int, optional): The maximum number of results to return at one time. Defaults to None.
        next_token(str, optional): A token to retrieve the next set of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.provisioning.template.version.list_all(
                ctx, template_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.provisioning.template.version.list_all template_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="list_provisioning_template_versions",
        op_kwargs={
            "templateName": template_name,
            "maxResults": max_results,
            "nextToken": next_token,
        },
    )
