"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    template_name: str,
    template_body: str,
    provisioning_role_arn: str,
    description: str = None,
    enabled: bool = None,
    pre_provisioning_hook: Dict = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a fleet provisioning template.

    Args:
        template_name(str): The name of the fleet provisioning template.
        description(str, optional): The description of the fleet provisioning template. Defaults to None.
        template_body(str): The JSON formatted contents of the fleet provisioning template.
        enabled(bool, optional): True to enable the fleet provisioning template, otherwise false. Defaults to None.
        provisioning_role_arn(str): The role ARN for the role associated with the fleet provisioning template. This IoT role grants permission to provision a device.
        pre_provisioning_hook(Dict, optional): Creates a pre-provisioning hook template. Defaults to None.
        tags(List, optional): Metadata which can be used to manage the fleet provisioning template.  For URI Request parameters use format: ...key1=value1&key2=value2... For the CLI command-line parameter use format: &&tags "key1=value1&key2=value2..." For the cli-input-json file use format: "tags": "key1=value1&key2=value2..." . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.provisioning.template.init.create(
                ctx, template_name=value, template_body=value, provisioning_role_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.provisioning.template.init.create template_name=value, template_body=value, provisioning_role_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="create_provisioning_template",
        op_kwargs={
            "templateName": template_name,
            "description": description,
            "templateBody": template_body,
            "enabled": enabled,
            "provisioningRoleArn": provisioning_role_arn,
            "preProvisioningHook": pre_provisioning_hook,
            "tags": tags,
        },
    )


async def delete(hub, ctx, template_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a fleet provisioning template.

    Args:
        template_name(str): The name of the fleet provision template to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.provisioning.template.init.delete(ctx, template_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.provisioning.template.init.delete template_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="delete_provisioning_template",
        op_kwargs={"templateName": template_name},
    )


async def describe(hub, ctx, template_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about a fleet provisioning template.

    Args:
        template_name(str): The name of the fleet provisioning template.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.provisioning.template.init.describe(
                ctx, template_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.provisioning.template.init.describe template_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="describe_provisioning_template",
        op_kwargs={"templateName": template_name},
    )


async def list_all(hub, ctx, max_results: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists the fleet provisioning templates in your AWS account.

    Args:
        max_results(int, optional): The maximum number of results to return at one time. Defaults to None.
        next_token(str, optional): A token to retrieve the next set of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.provisioning.template.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.provisioning.template.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="list_provisioning_templates",
        op_kwargs={"maxResults": max_results, "nextToken": next_token},
    )


async def update(
    hub,
    ctx,
    template_name: str,
    description: str = None,
    enabled: bool = None,
    default_version_id: int = None,
    provisioning_role_arn: str = None,
    pre_provisioning_hook: Dict = None,
    remove_pre_provisioning_hook: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a fleet provisioning template.

    Args:
        template_name(str): The name of the fleet provisioning template.
        description(str, optional): The description of the fleet provisioning template. Defaults to None.
        enabled(bool, optional): True to enable the fleet provisioning template, otherwise false. Defaults to None.
        default_version_id(int, optional): The ID of the default provisioning template version. Defaults to None.
        provisioning_role_arn(str, optional): The ARN of the role associated with the provisioning template. This IoT role grants permission to provision a device. Defaults to None.
        pre_provisioning_hook(Dict, optional): Updates the pre-provisioning hook template. Defaults to None.
        remove_pre_provisioning_hook(bool, optional): Removes pre-provisioning hook template. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.provisioning.template.init.update(ctx, template_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.provisioning.template.init.update template_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="update_provisioning_template",
        op_kwargs={
            "templateName": template_name,
            "description": description,
            "enabled": enabled,
            "defaultVersionId": default_version_id,
            "provisioningRoleArn": provisioning_role_arn,
            "preProvisioningHook": pre_provisioning_hook,
            "removePreProvisioningHook": remove_pre_provisioning_hook,
        },
    )
