"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, template_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Creates a provisioning claim.

    Args:
        template_name(str): The name of the provisioning template to use.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.provisioning.claim.create(ctx, template_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.provisioning.claim.create template_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="create_provisioning_claim",
        op_kwargs={"templateName": template_name},
    )
