"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def attach(hub, ctx, policy_name: str, principal: str) -> None:
    r"""
    **Autogenerated function**

    Attaches the specified policy to the specified principal (certificate or other credential).  Note: This API is deprecated. Please use AttachPolicy instead.

    Args:
        policy_name(str): The policy name.
        principal(str): The principal, which can be a certificate ARN (as returned from the CreateCertificate operation) or an Amazon Cognito ID.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.principal.policy.attach(
                ctx, policy_name=value, principal=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.principal.policy.attach policy_name=value, principal=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="attach_principal_policy",
        op_kwargs={"policyName": policy_name, "principal": principal},
    )


async def detach(hub, ctx, policy_name: str, principal: str) -> None:
    r"""
    **Autogenerated function**

    Removes the specified policy from the specified certificate.  Note: This API is deprecated. Please use DetachPolicy instead.

    Args:
        policy_name(str): The name of the policy to detach.
        principal(str): The principal. Valid principals are CertificateArn (arn:aws:iot:region:accountId:cert/certificateId), thingGroupArn (arn:aws:iot:region:accountId:thinggroup/groupName) and CognitoId (region:id).
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.principal.policy.detach(
                ctx, policy_name=value, principal=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.principal.policy.detach policy_name=value, principal=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="detach_principal_policy",
        op_kwargs={"policyName": policy_name, "principal": principal},
    )


async def list_all(
    hub,
    ctx,
    principal: str,
    marker: str = None,
    page_size: int = None,
    ascending_order: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the policies attached to the specified principal. If you use an Cognito identity, the ID must be in AmazonCognito Identity format.  Note: This API is deprecated. Please use ListAttachedPolicies instead.

    Args:
        principal(str): The principal. Valid principals are CertificateArn (arn:aws:iot:region:accountId:cert/certificateId), thingGroupArn (arn:aws:iot:region:accountId:thinggroup/groupName) and CognitoId (region:id).
        marker(str, optional): The marker for the next set of results. Defaults to None.
        page_size(int, optional): The result page size. Defaults to None.
        ascending_order(bool, optional): Specifies the order for results. If true, results are returned in ascending creation order. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.principal.policy.list_all(ctx, principal=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.principal.policy.list_all principal=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="list_principal_policies",
        op_kwargs={
            "principal": principal,
            "marker": marker,
            "pageSize": page_size,
            "ascendingOrder": ascending_order,
        },
    )
