"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub, ctx, policy_name: str, policy_document: str, set_as_default: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new version of the specified AWS IoT policy. To update a policy, create a new policy version. A managed policy can have up to five versions. If the policy has five versions, you must use DeletePolicyVersion to delete an existing version before you create a new one. Optionally, you can set the new version as the policy's default version. The default version is the operative version (that is, the version that is in effect for the certificates to which the policy is attached).

    Args:
        policy_name(str): The policy name.
        policy_document(str): The JSON document that describes the policy. Minimum length of 1. Maximum length of 2048, excluding whitespace.
        set_as_default(bool, optional): Specifies whether the policy version is set as the default. When this parameter is true, the new policy version becomes the operative version (that is, the version that is in effect for the certificates to which the policy is attached). Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.policy.version.create(
                ctx, policy_name=value, policy_document=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.policy.version.create policy_name=value, policy_document=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="create_policy_version",
        op_kwargs={
            "policyName": policy_name,
            "policyDocument": policy_document,
            "setAsDefault": set_as_default,
        },
    )


async def delete(hub, ctx, policy_name: str, policy_version_id: str) -> None:
    r"""
    **Autogenerated function**

    Deletes the specified version of the specified policy. You cannot delete the default version of a policy using this API. To delete the default version of a policy, use DeletePolicy. To find out which version of a policy is marked as the default version, use ListPolicyVersions.

    Args:
        policy_name(str): The name of the policy.
        policy_version_id(str): The policy version ID.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.policy.version.delete(
                ctx, policy_name=value, policy_version_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.policy.version.delete policy_name=value, policy_version_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="delete_policy_version",
        op_kwargs={"policyName": policy_name, "policyVersionId": policy_version_id},
    )


async def get(hub, ctx, policy_name: str, policy_version_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about the specified policy version.

    Args:
        policy_name(str): The name of the policy.
        policy_version_id(str): The policy version ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.policy.version.get(
                ctx, policy_name=value, policy_version_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.policy.version.get policy_name=value, policy_version_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="get_policy_version",
        op_kwargs={"policyName": policy_name, "policyVersionId": policy_version_id},
    )


async def list_all(hub, ctx, policy_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Lists the versions of the specified policy and identifies the default version.

    Args:
        policy_name(str): The policy name.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.policy.version.list_all(ctx, policy_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.policy.version.list_all policy_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="list_policy_versions",
        op_kwargs={"policyName": policy_name},
    )
