"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub,
    ctx,
    policy_name: str,
    marker: str = None,
    page_size: int = None,
    ascending_order: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the principals associated with the specified policy.  Note: This API is deprecated. Please use ListTargetsForPolicy instead.

    Args:
        policy_name(str): The policy name.
        marker(str, optional): The marker for the next set of results. Defaults to None.
        page_size(int, optional): The result page size. Defaults to None.
        ascending_order(bool, optional): Specifies the order for results. If true, the results are returned in ascending creation order. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.policy.principal.list_all(ctx, policy_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.policy.principal.list_all policy_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="list_policy_principals",
        op_kwargs={
            "policyName": policy_name,
            "marker": marker,
            "pageSize": page_size,
            "ascendingOrder": ascending_order,
        },
    )
