"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def attach(hub, ctx, policy_name: str, target: str) -> None:
    r"""
    **Autogenerated function**

    Attaches the specified policy to the specified principal (certificate or other credential).

    Args:
        policy_name(str): The name of the policy to attach.
        target(str): The identity to which the policy is attached. For example, a thing group or a certificate.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.policy.init.attach(ctx, policy_name=value, target=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.policy.init.attach policy_name=value, target=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="attach_policy",
        op_kwargs={"policyName": policy_name, "target": target},
    )


async def create(
    hub, ctx, policy_name: str, policy_document: str, tags: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an AWS IoT policy. The created policy is the default version for the policy. This operation creates a policy version with a version identifier of 1 and sets 1 as the policy's default version.

    Args:
        policy_name(str): The policy name.
        policy_document(str): The JSON document that describes the policy. policyDocument must have a minimum length of 1, with a maximum length of 2048, excluding whitespace.
        tags(List, optional): Metadata which can be used to manage the policy.  For URI Request parameters use format: ...key1=value1&key2=value2... For the CLI command-line parameter use format: &&tags "key1=value1&key2=value2..." For the cli-input-json file use format: "tags": "key1=value1&key2=value2..." . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.policy.init.create(
                ctx, policy_name=value, policy_document=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.policy.init.create policy_name=value, policy_document=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="create_policy",
        op_kwargs={
            "policyName": policy_name,
            "policyDocument": policy_document,
            "tags": tags,
        },
    )


async def delete(hub, ctx, policy_name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes the specified policy. A policy cannot be deleted if it has non-default versions or it is attached to any certificate. To delete a policy, use the DeletePolicyVersion API to delete all non-default versions of the policy; use the DetachPrincipalPolicy API to detach the policy from any certificate; and then use the DeletePolicy API to delete the policy. When a policy is deleted using DeletePolicy, its default version is deleted with it.

    Args:
        policy_name(str): The name of the policy to delete.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.policy.init.delete(ctx, policy_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.policy.init.delete policy_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="delete_policy",
        op_kwargs={"policyName": policy_name},
    )


async def detach(hub, ctx, policy_name: str, target: str) -> None:
    r"""
    **Autogenerated function**

    Detaches a policy from the specified target.

    Args:
        policy_name(str): The policy to detach.
        target(str): The target from which the policy will be detached.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.policy.init.detach(ctx, policy_name=value, target=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.policy.init.detach policy_name=value, target=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="detach_policy",
        op_kwargs={"policyName": policy_name, "target": target},
    )


async def get(hub, ctx, policy_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about the specified policy with the policy document of the default version.

    Args:
        policy_name(str): The name of the policy.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.policy.init.get(ctx, policy_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.policy.init.get policy_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="get_policy",
        op_kwargs={"policyName": policy_name},
    )


async def list_all(
    hub, ctx, marker: str = None, page_size: int = None, ascending_order: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists your policies.

    Args:
        marker(str, optional): The marker for the next set of results. Defaults to None.
        page_size(int, optional): The result page size. Defaults to None.
        ascending_order(bool, optional): Specifies the order for results. If true, the results are returned in ascending creation order. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.policy.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.policy.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="list_policies",
        op_kwargs={
            "marker": marker,
            "pageSize": page_size,
            "ascendingOrder": ascending_order,
        },
    )
