"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def get_all(
    hub,
    ctx,
    query_string: str,
    index_name: str = None,
    aggregation_field: str = None,
    query_version: str = None,
    percents: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Groups the aggregated values that match the query into percentile groupings. The default percentile groupings are: 1,5,25,50,75,95,99, although you can specify your own when you call GetPercentiles. This function returns a value for each percentile group specified (or the default percentile groupings). The percentile group "1" contains the aggregated field value that occurs in approximately one percent of the values that match the query. The percentile group "5" contains the aggregated field value that occurs in approximately five percent of the values that match the query, and so on. The result is an approximation, the more values that match the query, the more accurate the percentile values.

    Args:
        index_name(str, optional): The name of the index to search. Defaults to None.
        query_string(str): The query string.
        aggregation_field(str, optional): The field to aggregate. Defaults to None.
        query_version(str, optional): The query version. Defaults to None.
        percents(List, optional): The percentile groups returned. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.percentile.get_all(ctx, query_string=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.percentile.get_all query_string=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="get_percentiles",
        op_kwargs={
            "indexName": index_name,
            "queryString": query_string,
            "aggregationField": aggregation_field,
            "queryVersion": query_version,
            "percents": percents,
        },
    )
