"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub, ctx, page_size: int = None, marker: str = None, ascending_order: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists certificates that are being transferred but not yet accepted.

    Args:
        page_size(int, optional): The result page size. Defaults to None.
        marker(str, optional): The marker for the next set of results. Defaults to None.
        ascending_order(bool, optional): Specifies the order for results. If True, the results are returned in ascending order, based on the creation date. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.outgoing_certificate.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.outgoing_certificate.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="list_outgoing_certificates",
        op_kwargs={
            "pageSize": page_size,
            "marker": marker,
            "ascendingOrder": ascending_order,
        },
    )
