"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    ota_update_id: str,
    targets: List,
    files: List,
    role_arn: str,
    description: str = None,
    protocols: List = None,
    target_selection: str = None,
    aws_job_executions_rollout_config: Dict = None,
    aws_job_presigned_url_config: Dict = None,
    aws_job_abort_config: Dict = None,
    aws_job_timeout_config: Dict = None,
    additional_parameters: Dict = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an AWS IoT OTAUpdate on a target group of things or groups.

    Args:
        ota_update_id(str): The ID of the OTA update to be created.
        description(str, optional): The description of the OTA update. Defaults to None.
        targets(List): The devices targeted to receive OTA updates.
        protocols(List, optional): The protocol used to transfer the OTA update image. Valid values are [HTTP], [MQTT], [HTTP, MQTT]. When both HTTP and MQTT are specified, the target device can choose the protocol. Defaults to None.
        target_selection(str, optional): Specifies whether the update will continue to run (CONTINUOUS), or will be complete after all the things specified as targets have completed the update (SNAPSHOT). If continuous, the update may also be run on a thing when a change is detected in a target. For example, an update will run on a thing when the thing is added to a target group, even after the update was completed by all things originally in the group. Valid values: CONTINUOUS | SNAPSHOT. Defaults to None.
        aws_job_executions_rollout_config(Dict, optional): Configuration for the rollout of OTA updates. Defaults to None.
        aws_job_presigned_url_config(Dict, optional): Configuration information for pre-signed URLs. Defaults to None.
        aws_job_abort_config(Dict, optional): The criteria that determine when and how a job abort takes place. Defaults to None.
        aws_job_timeout_config(Dict, optional): Specifies the amount of time each device has to finish its execution of the job. A timer is started when the job execution status is set to IN_PROGRESS. If the job execution status is not set to another terminal state before the timer expires, it will be automatically set to TIMED_OUT. Defaults to None.
        files(List): The files to be streamed by the OTA update.
        role_arn(str): The IAM role that grants AWS IoT access to the Amazon S3, AWS IoT jobs and AWS Code Signing resources to create an OTA update job.
        additional_parameters(Dict, optional): A list of additional OTA update parameters which are name-value pairs. Defaults to None.
        tags(List, optional): Metadata which can be used to manage updates. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.ota_update.create(
                ctx, ota_update_id=value, targets=value, files=value, role_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.ota_update.create ota_update_id=value, targets=value, files=value, role_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="create_ota_update",
        op_kwargs={
            "otaUpdateId": ota_update_id,
            "description": description,
            "targets": targets,
            "protocols": protocols,
            "targetSelection": target_selection,
            "awsJobExecutionsRolloutConfig": aws_job_executions_rollout_config,
            "awsJobPresignedUrlConfig": aws_job_presigned_url_config,
            "awsJobAbortConfig": aws_job_abort_config,
            "awsJobTimeoutConfig": aws_job_timeout_config,
            "files": files,
            "roleArn": role_arn,
            "additionalParameters": additional_parameters,
            "tags": tags,
        },
    )


async def delete(
    hub,
    ctx,
    ota_update_id: str,
    delete_stream: bool = None,
    force_delete_aws_job: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Delete an OTA update.

    Args:
        ota_update_id(str): The ID of the OTA update to delete.
        delete_stream(bool, optional): When true, the stream created by the OTAUpdate process is deleted when the OTA update is deleted. Ignored if the stream specified in the OTAUpdate is supplied by the user. Defaults to None.
        force_delete_aws_job(bool, optional): When true, deletes the AWS job created by the OTAUpdate process even if it is "IN_PROGRESS". Otherwise, if the job is not in a terminal state ("COMPLETED" or "CANCELED") an exception will occur. The default is false. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.ota_update.delete(ctx, ota_update_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.ota_update.delete ota_update_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="delete_ota_update",
        op_kwargs={
            "otaUpdateId": ota_update_id,
            "deleteStream": delete_stream,
            "forceDeleteAWSJob": force_delete_aws_job,
        },
    )


async def get(hub, ctx, ota_update_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets an OTA update.

    Args:
        ota_update_id(str): The OTA update ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.ota_update.get(ctx, ota_update_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.ota_update.get ota_update_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="get_ota_update",
        op_kwargs={"otaUpdateId": ota_update_id},
    )


async def list_all(
    hub,
    ctx,
    max_results: int = None,
    next_token: str = None,
    ota_update_status: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists OTA updates.

    Args:
        max_results(int, optional): The maximum number of results to return at one time. Defaults to None.
        next_token(str, optional): A token used to retrieve the next set of results. Defaults to None.
        ota_update_status(str, optional): The OTA update job status. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.ota_update.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.ota_update.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="list_ota_updates",
        op_kwargs={
            "maxResults": max_results,
            "nextToken": next_token,
            "otaUpdateStatus": ota_update_status,
        },
    )
