"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def start(hub, ctx, target_check_names: List) -> Dict:
    r"""
    **Autogenerated function**

    Starts an on-demand Device Defender audit.

    Args:
        target_check_names(List): Which checks are performed during the audit. The checks you specify must be enabled for your account or an exception occurs. Use DescribeAccountAuditConfiguration to see the list of all checks, including those that are enabled or UpdateAccountAuditConfiguration to select which checks are enabled.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.on_demand_audit_task.start(ctx, target_check_names=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.on_demand_audit_task.start target_check_names=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="start_on_demand_audit_task",
        op_kwargs={"targetCheckNames": target_check_names},
    )
