"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub, ctx, action_name: str, role_arn: str, action_params: Dict, tags: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    Defines an action that can be applied to audit findings by using StartAuditMitigationActionsTask. Only certain types of mitigation actions can be applied to specific check names. For more information, see Mitigation actions. Each mitigation action can apply only one type of change.

    Args:
        action_name(str): A friendly name for the action. Choose a friendly name that accurately describes the action (for example, EnableLoggingAction).
        role_arn(str): The ARN of the IAM role that is used to apply the mitigation action.
        action_params(Dict): Defines the type of action and the parameters for that action.
        tags(List, optional): Metadata that can be used to manage the mitigation action. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.mitigation_action.create(
                ctx, action_name=value, role_arn=value, action_params=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.mitigation_action.create action_name=value, role_arn=value, action_params=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="create_mitigation_action",
        op_kwargs={
            "actionName": action_name,
            "roleArn": role_arn,
            "actionParams": action_params,
            "tags": tags,
        },
    )


async def delete(hub, ctx, action_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a defined mitigation action from your AWS account.

    Args:
        action_name(str): The name of the mitigation action that you want to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.mitigation_action.delete(ctx, action_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.mitigation_action.delete action_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="delete_mitigation_action",
        op_kwargs={"actionName": action_name},
    )


async def describe(hub, ctx, action_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about a mitigation action.

    Args:
        action_name(str): The friendly name that uniquely identifies the mitigation action.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.mitigation_action.describe(ctx, action_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.mitigation_action.describe action_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="describe_mitigation_action",
        op_kwargs={"actionName": action_name},
    )


async def list_all(
    hub, ctx, action_type: str = None, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Gets a list of all mitigation actions that match the specified filter criteria.

    Args:
        action_type(str, optional): Specify a value to limit the result to mitigation actions with a specific action type. Defaults to None.
        max_results(int, optional): The maximum number of results to return at one time. The default is 25. Defaults to None.
        next_token(str, optional): The token for the next set of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.mitigation_action.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.mitigation_action.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="list_mitigation_actions",
        op_kwargs={
            "actionType": action_type,
            "maxResults": max_results,
            "nextToken": next_token,
        },
    )


async def update(
    hub, ctx, action_name: str, role_arn: str = None, action_params: Dict = None
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the definition for the specified mitigation action.

    Args:
        action_name(str): The friendly name for the mitigation action. You cannot change the name by using UpdateMitigationAction. Instead, you must delete and recreate the mitigation action with the new name.
        role_arn(str, optional): The ARN of the IAM role that is used to apply the mitigation action. Defaults to None.
        action_params(Dict, optional): Defines the type of action and the parameters for that action. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.mitigation_action.update(ctx, action_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.mitigation_action.update action_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="update_mitigation_action",
        op_kwargs={
            "actionName": action_name,
            "roleArn": role_arn,
            "actionParams": action_params,
        },
    )
