"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"set_": "set"}


async def get_all(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Gets the logging options. NOTE: use of this command is not recommended. Use GetV2LoggingOptions instead.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.logging_option.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.logging_option.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="iot", operation="get_logging_options", op_kwargs={}
    )


async def set_(hub, ctx, logging_options_payload: Dict) -> None:
    r"""
    **Autogenerated function**

    Sets the logging options. NOTE: use of this command is not recommended. Use SetV2LoggingOptions instead.

    Args:
        logging_options_payload(Dict): The logging options payload.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.logging_option.set(ctx, logging_options_payload=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.logging_option.set logging_options_payload=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="set_logging_options",
        op_kwargs={"loggingOptionsPayload": logging_options_payload},
    )
