"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, set_as_active: bool = None) -> Dict:
    r"""
    **Autogenerated function**

    Creates a 2048-bit RSA key pair and issues an X.509 certificate using the issued public key. You can also call CreateKeysAndCertificate over MQTT from a device, for more information, see Provisioning MQTT API.  Note This is the only time AWS IoT issues the private key for this certificate, so it is important to keep it in a secure location.

    Args:
        set_as_active(bool, optional): Specifies whether the certificate is active. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.keys_and_certificate.create(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.keys_and_certificate.create
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="create_keys_and_certificate",
        op_kwargs={"setAsActive": set_as_active},
    )
