"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(
    hub,
    ctx,
    status: str = None,
    target_selection: str = None,
    max_results: int = None,
    next_token: str = None,
    thing_group_name: str = None,
    thing_group_id: str = None,
    namespace_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists jobs.

    Args:
        status(str, optional): An optional filter that lets you search for jobs that have the specified status. Defaults to None.
        target_selection(str, optional): Specifies whether the job will continue to run (CONTINUOUS), or will be complete after all those things specified as targets have completed the job (SNAPSHOT). If continuous, the job may also be run on a thing when a change is detected in a target. For example, a job will run on a thing when the thing is added to a target group, even after the job was completed by all things originally in the group. . Defaults to None.
        max_results(int, optional): The maximum number of results to return per request. Defaults to None.
        next_token(str, optional): The token to retrieve the next set of results. Defaults to None.
        thing_group_name(str, optional): A filter that limits the returned jobs to those for the specified group. Defaults to None.
        thing_group_id(str, optional): A filter that limits the returned jobs to those for the specified group. Defaults to None.
        namespace_id(str, optional): The namespace used to indicate that a job is a customer-managed job. When you specify a value for this parameter, AWS IoT Core sends jobs notifications to MQTT topics that contain the value in the following format.  $aws/things/THING_NAME/jobs/JOB_ID/notify-namespace-NAMESPACE_ID/   The namespaceId feature is in public preview. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot.jobs.list(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot.jobs.list
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot",
        operation="list_jobs",
        op_kwargs={
            "status": status,
            "targetSelection": target_selection,
            "maxResults": max_results,
            "nextToken": next_token,
            "thingGroupName": thing_group_name,
            "thingGroupId": thing_group_id,
            "namespaceId": namespace_id,
        },
    )
